using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            IntPtr root, grp;
            int annot, ocmd, oc1, oc2, oc3;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            // Disable color key masking for images
            pdf.SetUseTransparency(false);

            // Create three layers
            oc1 = pdf.CreateOCG("All", false, true, TOCGIntent.oiAll);
            oc2 = pdf.CreateOCG("Text and Annotations", false, true, TOCGIntent.oiAll);
            oc3 = pdf.CreateOCG("Images", false, true, TOCGIntent.oiAll);

            root = pdf.AddLayerToDisplTree(IntPtr.Zero, oc1, "A layer group with a title");
            grp  = pdf.AddLayerToDisplTree(root, -1, null);
            pdf.AddLayerToDisplTree(grp, oc2, null);
            pdf.AddLayerToDisplTree(grp, oc3, null);

            pdf.Append();
               // The main layer controls the visibility of all three layers in this example.
               pdf.BeginLayer(oc1);
                  pdf.BeginLayer(oc2);
                     pdf.SetFont("Helvetica", TFStyle.fsRegular, 12.0, false, TCodepage.cp1252);
                     String someText = "Some text with a link!!!";
                     pdf.SetFillColor(CPDF.PDF_BLUE);
                     pdf.WriteText(50.0, 50.0, someText);
                     double tw = pdf.GetTextWidth(someText);
                     // To reflect the same nesting as the text layer we must use an OCMD for the annotation
                     // because the visibility of the layer oc2 depends on oc1 at this position.
                     pdf.SetBorderStyle(TBorderStyle.bsUnderline);
                     pdf.SetStrokeColor(CPDF.PDF_BLUE);
                     annot = pdf.WebLink(50.0, 51.0, tw, 12.0, "www.dynaforms.com");

                     int[] array = {oc1, oc2};
                     ocmd = pdf.CreateOCMD(TOCVisibility.ovAllOn, array);
                     pdf.AddObjectToLayer(ocmd, TOCObject.ooAnnotation, annot);
                  pdf.EndLayer();

                  pdf.BeginLayer(oc3);
                     pdf.InsertImageEx(50.0, 70.0, 300.0, 200.0, "../../../../test_files/images/margarita-102572_640.jpg", 1);
                  pdf.EndLayer();
               pdf.EndLayer();

               pdf.SetFillColor(CPDF.PDF_BLACK);
               pdf.WriteText(50.0, 300.0, "This text is not part of a layer!");
            pdf.EndPage();

            pdf.SetPageMode(TPageMode.pmUseOC);

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
